<?php
/**
 * The template part for displaying social links.
 *
 * @package Revision
 */

$social_icons = array(
	'facebook'  => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" ><path d="M12 2C6.477 2 2 6.477 2 12C2 16.991 5.657 21.128 10.438 21.879V14.89H7.898V12H10.438V9.797C10.438 7.291 11.93 5.907 14.215 5.907C15.309 5.907 16.453 6.102 16.453 6.102V8.562H15.193C13.95 8.562 13.563 9.333 13.563 10.124V12H16.336L15.893 14.89H13.563V21.879C18.343 21.129 22 16.99 22 12C22 6.477 17.523 2 12 2Z" fill="#29294B"/></svg>',
	'instagram' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" ><path d="M7.85844 2.06995C6.79443 2.12015 6.06783 2.28995 5.43263 2.53955C4.77523 2.79575 4.21802 3.13955 3.66362 3.69596C3.10922 4.25236 2.76782 4.80996 2.51342 5.46836C2.26722 6.10497 2.10042 6.83217 2.05342 7.89677C2.00642 8.96138 1.99602 9.30358 2.00122 12.0192C2.00642 14.7348 2.01842 15.0752 2.07002 16.142C2.12082 17.2058 2.29002 17.9322 2.53962 18.5676C2.79622 19.225 3.13962 19.782 3.69622 20.3366C4.25282 20.8912 4.81003 21.2318 5.47003 21.4866C6.10603 21.7324 6.83343 21.9 7.89784 21.9466C8.96224 21.9932 9.30484 22.004 12.0197 21.9988C14.7345 21.9936 15.0763 21.9816 16.1429 21.931C17.2095 21.8804 17.9321 21.71 18.5677 21.4616C19.2251 21.2044 19.7825 20.8616 20.3367 20.3048C20.8909 19.748 21.2321 19.19 21.4863 18.5312C21.7327 17.8952 21.9001 17.1678 21.9463 16.1042C21.9929 15.0368 22.0039 14.696 21.9987 11.9808C21.9935 9.26558 21.9813 8.92518 21.9307 7.85877C21.8801 6.79237 21.7107 6.06817 21.4613 5.43236C21.2043 4.77496 20.8613 4.21836 20.3049 3.66336C19.7485 3.10835 19.1901 2.76735 18.5315 2.51375C17.8951 2.26755 17.1681 2.09975 16.1037 2.05375C15.0393 2.00775 14.6967 1.99595 11.9809 2.00115C9.26504 2.00635 8.92504 2.01795 7.85844 2.06995ZM7.97524 20.1476C7.00023 20.1052 6.47083 19.9432 6.11803 19.8076C5.65083 19.6276 5.31803 19.41 4.96643 19.0618C4.61483 18.7136 4.39882 18.3796 4.21642 17.9134C4.07942 17.5606 3.91442 17.0318 3.86882 16.0568C3.81922 15.003 3.80882 14.6866 3.80302 12.0168C3.79722 9.34698 3.80742 9.03098 3.85362 7.97677C3.89522 7.00257 4.05822 6.47257 4.19362 6.11997C4.37362 5.65216 4.59043 5.31996 4.93943 4.96856C5.28843 4.61716 5.62143 4.40076 6.08803 4.21836C6.44043 4.08076 6.96923 3.91716 7.94384 3.87076C8.99844 3.82076 9.31444 3.81076 11.9839 3.80496C14.6533 3.79916 14.9701 3.80916 16.0251 3.85556C16.9993 3.89796 17.5295 4.05936 17.8817 4.19556C18.3491 4.37556 18.6817 4.59176 19.0331 4.94136C19.3845 5.29096 19.6011 5.62276 19.7835 6.09037C19.9213 6.44177 20.0849 6.97037 20.1309 7.94557C20.1811 9.00018 20.1925 9.31638 20.1973 11.9856C20.2021 14.6548 20.1927 14.9718 20.1465 16.0256C20.1039 17.0006 19.9423 17.5302 19.8065 17.8834C19.6265 18.3504 19.4095 18.6834 19.0603 19.0346C18.7111 19.3858 18.3785 19.6022 17.9117 19.7846C17.5597 19.922 17.0303 20.086 16.0565 20.1324C15.0019 20.182 14.6859 20.1924 12.0155 20.1982C9.34504 20.204 9.03004 20.1932 7.97544 20.1476M16.1275 6.65537C16.1279 6.89272 16.1986 7.12463 16.3308 7.32176C16.463 7.51888 16.6507 7.67238 16.8702 7.76283C17.0896 7.85327 17.331 7.87661 17.5637 7.82989C17.7964 7.78317 18.01 7.66848 18.1776 7.50034C18.3451 7.3322 18.459 7.11815 18.5049 6.88527C18.5507 6.65239 18.5265 6.41113 18.4352 6.19202C18.344 5.97291 18.1898 5.78578 17.9922 5.65429C17.7946 5.52281 17.5624 5.45289 17.3251 5.45336C17.0069 5.454 16.702 5.58098 16.4774 5.80639C16.2528 6.0318 16.1269 6.33718 16.1275 6.65537ZM6.86543 12.01C6.87103 14.846 9.17424 17.1398 12.0097 17.1344C14.8451 17.129 17.1405 14.826 17.1351 11.99C17.1297 9.15398 14.8259 6.85957 11.9901 6.86517C9.15424 6.87077 6.86003 9.17438 6.86543 12.01ZM8.66664 12.0064C8.66534 11.3471 8.85956 10.7022 9.22476 10.1533C9.58995 9.60444 10.1097 9.17616 10.7183 8.92265C11.3269 8.66915 11.997 8.60181 12.6439 8.72915C13.2908 8.85649 13.8853 9.17279 14.3524 9.63805C14.8196 10.1033 15.1382 10.6966 15.2681 11.343C15.398 11.9894 15.3333 12.6597 15.0822 13.2693C14.8311 13.8789 14.4049 14.4004 13.8575 14.7677C13.31 15.1351 12.6659 15.3319 12.0067 15.3332C11.5689 15.3341 11.1352 15.2488 10.7304 15.0821C10.3257 14.9154 9.95768 14.6706 9.64752 14.3617C9.33736 14.0527 9.0911 13.6857 8.9228 13.2816C8.7545 12.8775 8.66745 12.4442 8.66664 12.0064Z" fill="#29294B"/></svg>',
	'twitter'   => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" ><path d="M13.8999 10.472L21.3326 2.02222H19.5713L13.1175 9.35906L7.96285 2.02222H2.01758L9.81242 13.1168L2.01758 21.9777H3.77899L10.5944 14.2298L16.0381 21.9777H21.9834L13.8995 10.472H13.8999ZM11.4874 13.2146L10.6977 12.1098L4.41365 3.31901H7.11908L12.1903 10.4135L12.9801 11.5182L19.5722 20.7399H16.8667L11.4874 13.215V13.2146Z" fill="#29294B"/></svg>',
	'youtube'   => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20"><path d="M8.2 13L12.871 10.3L8.2 7.6V13ZM18.604 5.953C18.721 6.376 18.802 6.943 18.856 7.663C18.919 8.383 18.946 9.004 18.946 9.544L19 10.3C19 12.271 18.856 13.72 18.604 14.647C18.379 15.457 17.857 15.979 17.047 16.204C16.624 16.321 15.85 16.402 14.662 16.456C13.492 16.519 12.421 16.546 11.431 16.546L10 16.6C6.229 16.6 3.88 16.456 2.953 16.204C2.143 15.979 1.621 15.457 1.396 14.647C1.279 14.224 1.198 13.657 1.144 12.937C1.081 12.217 1.054 11.596 1.054 11.056L1 10.3C1 8.329 1.144 6.88 1.396 5.953C1.621 5.143 2.143 4.621 2.953 4.396C3.376 4.279 4.15 4.198 5.338 4.144C6.508 4.081 7.579 4.054 8.569 4.054L10 4C13.771 4 16.12 4.144 17.047 4.396C17.857 4.621 18.379 5.143 18.604 5.953Z"/></svg>',
	'linkedin'  => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M3.66667 2C2.74619 2 2 2.74619 2 3.66667V20.3333C2 21.2538 2.74619 22 3.66667 22H20.3333C21.2538 22 22 21.2538 22 20.3333V3.66667C22 2.74619 21.2538 2 20.3333 2H3.66667ZM8.13418 6.44747C8.14043 7.50997 7.34512 8.16466 6.40137 8.15997C5.5123 8.15528 4.7373 7.44747 4.74199 6.44903C4.74668 5.50997 5.48887 4.75528 6.45293 4.77716C7.43106 4.79903 8.14043 5.51622 8.13418 6.44747ZM12.3108 9.51307H9.51079H9.50922V19.024H12.4686V18.8021C12.4686 18.38 12.4682 17.9578 12.4679 17.5354C12.467 16.409 12.466 15.2813 12.4718 14.1552C12.4733 13.8818 12.4858 13.5974 12.5561 13.3364C12.8201 12.3614 13.6968 11.7318 14.6749 11.8866C15.303 11.9849 15.7186 12.349 15.8936 12.9412C16.0014 13.3114 16.0499 13.7099 16.0546 14.0959C16.0672 15.2599 16.0654 16.4239 16.0637 17.588C16.063 17.9989 16.0623 18.41 16.0623 18.8209V19.0224H19.0311V18.7943C19.0311 18.2921 19.0309 17.79 19.0306 17.2879C19.03 16.0329 19.0293 14.7779 19.0327 13.5224C19.0342 12.9552 18.9733 12.3959 18.8342 11.8474C18.6264 11.0318 18.1968 10.3568 17.4983 9.86933C17.003 9.52243 16.4592 9.299 15.8514 9.274C15.7822 9.27112 15.7124 9.26736 15.6423 9.26357C15.3316 9.24677 15.0157 9.2297 14.7186 9.28962C13.8686 9.45993 13.1218 9.849 12.5577 10.5349C12.4921 10.6136 12.428 10.6934 12.3323 10.8127L12.3108 10.8397V9.51307ZM4.9796 19.0271H7.92491V9.51926H4.9796V19.0271Z" fill="#29294B"/></svg>',
	'pinterest' => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20"><path d="M10.0021 1C5.03125 1 1 5.02933 1 9.99786C1 13.681 3.21796 16.8465 6.38928 18.2408C6.36528 17.6135 6.385 16.8585 6.54618 16.1755L7.7036 11.2713C7.7036 11.2713 7.41381 10.6971 7.41381 9.84875C7.41381 8.51535 8.18543 7.51959 9.14994 7.51959C9.97042 7.51959 10.3639 8.13402 10.3639 8.86927C10.3639 9.69193 9.83753 10.9216 9.56833 12.0622C9.34284 13.0186 10.0459 13.7932 10.9915 13.7932C12.6951 13.7932 13.8439 11.6046 13.8439 9.00981C13.8439 7.03713 12.5142 5.5632 10.0982 5.5632C7.37009 5.5632 5.66568 7.60014 5.66568 9.8736C5.66568 10.6568 5.89888 11.2104 6.26068 11.6363C6.42529 11.8334 6.4493 11.914 6.38928 12.1385C6.3447 12.3039 6.24868 12.7015 6.2041 12.8617C6.14408 13.0906 5.9589 13.1711 5.75399 13.0871C4.49626 12.573 3.90984 11.1993 3.90984 9.64823C3.90984 7.09369 6.06778 4.02842 10.3434 4.02842C13.7796 4.02842 16.0422 6.51526 16.0422 9.18205C16.0422 12.7126 14.0771 15.3486 11.1836 15.3486C10.2113 15.3486 9.29912 14.8224 8.98533 14.2277C8.98533 14.2277 8.46235 16.3006 8.35089 16.7017C8.16228 17.3967 7.78762 18.0882 7.44639 18.6298C8.27459 18.8749 9.13451 18.9983 9.99786 19C14.9696 19 19 14.9707 19 10.0021C19 5.03275 14.973 1 10.0021 1Z"/></svg>',
	'dribbble'  => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20"><path d="M10 18.75C5.17656 18.75 1.25 14.8234 1.25 10C1.25 5.17656 5.17656 1.25 10 1.25C14.8234 1.25 18.75 5.17656 18.75 10C18.75 14.8234 14.8234 18.75 10 18.75ZM17.3792 11.1973C17.124 11.1171 15.0677 10.5024 12.7242 10.8779C13.7013 13.5642 14.1001 15.7517 14.1767 16.2067C15.0243 15.6345 15.7459 14.8949 16.297 14.0334C16.8482 13.1719 17.2172 12.2067 17.3814 11.1973H17.3792ZM12.9203 16.8906C12.8088 16.2344 12.3734 13.9506 11.3234 11.225L11.2753 11.2396C7.05344 12.7089 5.54406 15.6328 5.41281 15.9063C6.72107 16.9325 8.33653 17.4888 9.99927 17.4856C11.0347 17.4856 12.0191 17.2742 12.9159 16.8921L12.9203 16.8906ZM4.4474 15.0094C4.61656 14.7177 6.66771 11.3234 10.5228 10.0766C10.621 10.044 10.7194 10.0148 10.8181 9.98906C10.6276 9.56177 10.4253 9.13885 10.2115 8.72031C6.47813 9.83594 2.85854 9.78854 2.53042 9.78125L2.5275 10.0087C2.5275 11.9286 3.25521 13.6816 4.44813 15.0072L4.4474 15.0094ZM2.68281 8.47969C3.01823 8.48552 6.0975 8.49865 9.59313 7.56969C8.74709 6.08058 7.82216 4.63769 6.82229 3.24719C5.77579 3.74018 4.85758 4.46869 4.13957 5.3757C3.42155 6.28271 2.9232 7.3436 2.68354 8.47531L2.68281 8.47969ZM8.25 2.74625C8.45563 3.02333 9.81406 4.87104 11.0369 7.12125C13.6947 6.12594 14.8212 4.61292 14.9547 4.42188C13.5908 3.20608 11.8271 2.53487 10 2.53625C9.39844 2.53625 8.81146 2.60917 8.25 2.74406V2.74625ZM15.7859 5.28594C15.627 5.4974 14.375 7.10375 11.6122 8.23177C11.7872 8.58906 11.9549 8.95 12.108 9.31531C12.1664 9.44656 12.2174 9.57781 12.2684 9.70177C14.7549 9.38823 17.2268 9.89135 17.4747 9.9424C17.4601 8.17781 16.833 6.55906 15.7903 5.29031L15.7859 5.28594Z"/></svg>',
	'behance'   => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.48917 9.46828C8.93941 9.26827 9.32641 8.94899 9.60833 8.54495C9.87352 8.10574 10.0042 7.59845 9.98417 7.08578C10.0016 6.61711 9.9151 6.15039 9.73083 5.71911C9.57992 5.35192 9.33224 5.03252 9.01417 4.79495C8.68083 4.55328 8.30167 4.38911 7.90333 4.31495C7.43287 4.21044 6.9519 4.16066 6.47 4.16661H1.5C1.4337 4.16661 1.37011 4.19295 1.32322 4.23984C1.27634 4.28672 1.25 4.35031 1.25 4.41661V15.5341C1.25 15.6004 1.27634 15.664 1.32322 15.7109C1.37011 15.7578 1.4337 15.7841 1.5 15.7841H6.58333C7.07 15.7841 7.555 15.7191 8.025 15.5899C8.47459 15.4667 8.8983 15.2634 9.27583 14.9899C9.64866 14.7154 9.94899 14.3541 10.1508 13.9374C10.3788 13.4625 10.4897 12.9399 10.4742 12.4133C10.4915 11.7622 10.318 11.1203 9.975 10.5666C9.61884 10.0231 9.07363 9.63113 8.445 9.46661L8.48917 9.46828ZM3.79167 6.04161C3.74746 6.04161 3.70507 6.05917 3.67382 6.09043C3.64256 6.12169 3.625 6.16408 3.625 6.20828V8.79162C3.625 8.88328 3.7 8.95828 3.79167 8.95828H6.125C6.51177 8.95828 6.88271 8.80464 7.1562 8.53115C7.42969 8.25766 7.58333 7.88672 7.58333 7.49995C7.58333 7.11317 7.42969 6.74224 7.1562 6.46875C6.88271 6.19526 6.51177 6.04161 6.125 6.04161H3.79167ZM3.625 10.5833C3.625 10.4916 3.7 10.4166 3.79167 10.4166H6.22917C6.69882 10.4166 7.14924 10.6032 7.48133 10.9353C7.81343 11.2674 8 11.7178 8 12.1874C8 12.6571 7.81343 13.1075 7.48133 13.4396C7.14924 13.7717 6.69882 13.9583 6.22917 13.9583H3.79167C3.74746 13.9583 3.70507 13.9407 3.67382 13.9095C3.64256 13.8782 3.625 13.8358 3.625 13.7916V10.5833Z"/><path d="M12.8658 4.75828H16.8017C16.8674 4.75828 16.9305 4.78416 16.9773 4.83032C17.0241 4.87649 17.0508 4.93922 17.0517 5.00495L17.0625 5.80661C17.0629 5.83972 17.0568 5.87259 17.0444 5.90331C17.0321 5.93403 17.0137 5.96198 16.9905 5.98555C16.9672 6.00912 16.9395 6.02783 16.9089 6.0406C16.8784 6.05338 16.8456 6.05995 16.8125 6.05995H12.8658C12.7995 6.05995 12.7359 6.03361 12.6891 5.98672C12.6422 5.93984 12.6158 5.87625 12.6158 5.80995V5.00828C12.6158 4.94198 12.6422 4.87839 12.6891 4.8315C12.7359 4.78462 12.7995 4.75828 12.8658 4.75828Z"/><path fill-rule="evenodd" clip-rule="evenodd" d="M14.9767 14.0583C15.3823 14.0703 15.7808 13.9504 16.1125 13.7166C16.3292 13.5724 16.5017 13.3666 16.6108 13.1233C16.6245 13.0916 16.647 13.0645 16.6757 13.0453C16.7044 13.026 16.738 13.0155 16.7725 13.0149H18.3733C18.4817 13.0149 18.5617 13.1166 18.5292 13.2199C18.292 14.0026 17.8137 14.6903 17.1625 15.1849C16.4771 15.631 15.6715 15.8564 14.8542 15.8308C14.2733 15.8412 13.6963 15.7346 13.1575 15.5174C12.6675 15.3105 12.2311 14.9944 11.8817 14.5933C11.536 14.1767 11.2745 13.697 11.1117 13.1808C10.9175 12.6038 10.8231 11.9979 10.8325 11.3891C10.8268 10.7889 10.9244 10.1921 11.1208 9.62495C11.301 9.10642 11.5832 8.62925 11.9508 8.22161C12.3125 7.82975 12.75 7.51535 13.2367 7.29745C13.7601 7.0682 14.326 6.95178 14.8975 6.95578C15.5062 6.94674 16.1074 7.08997 16.6467 7.37245C17.1401 7.64543 17.5647 8.02733 17.8883 8.48911C18.2142 8.97078 18.4517 9.51245 18.5875 10.0866C18.7278 10.6918 18.7777 11.3143 18.7358 11.9341H12.9483C12.9207 12.5243 13.1138 13.1036 13.49 13.5591C13.6917 13.7458 13.9283 13.8866 14.1842 13.9724C14.44 14.0583 14.71 14.0874 14.9767 14.0583ZM13 10.3324C12.9999 10.3435 13.002 10.3545 13.0062 10.3648C13.0104 10.3751 13.0166 10.3844 13.0244 10.3922C13.0322 10.4 13.0416 10.4062 13.0518 10.4104C13.0621 10.4146 13.0731 10.4167 13.0842 10.4166H16.4575C16.4798 10.4166 16.5012 10.4077 16.517 10.392C16.5328 10.3762 16.5417 10.3548 16.5417 10.3324C16.5417 9.88512 16.364 9.45611 16.0477 9.13979C15.7313 8.82348 15.3023 8.64578 14.855 8.64578H14.6867C14.2393 8.64578 13.8103 8.82348 13.494 9.13979C13.1777 9.45611 13 9.88512 13 10.3324Z"/></svg>',
	'reddit'    => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20"><path d="M10.0013 18.3327C5.39893 18.3327 1.66797 14.6017 1.66797 9.99935C1.66797 5.39697 5.39893 1.66602 10.0013 1.66602C14.6037 1.66602 18.3347 5.39697 18.3347 9.99935C18.3347 14.6017 14.6037 18.3327 10.0013 18.3327ZM15.5597 9.99935C15.5422 9.52018 15.2448 9.09602 14.8003 8.91602C14.3559 8.7361 13.8472 8.83402 13.5013 9.16602C12.5533 8.5216 11.439 8.1656 10.293 8.14102L10.8347 5.54102L12.618 5.91602C12.6617 6.32311 12.9948 6.63807 13.4037 6.65912C13.8126 6.68015 14.1762 6.40102 14.2616 6.00057C14.3469 5.60013 14.1287 5.19701 13.7467 5.04951C13.3648 4.902 12.9322 5.05382 12.7263 5.40768L10.6847 4.99935C10.6172 4.98455 10.5467 4.99737 10.4887 5.03495C10.4307 5.07252 10.3903 5.13173 10.3763 5.19935L9.75965 8.09102C8.59957 8.10851 7.46986 8.46477 6.50964 9.11602C6.15859 8.78568 5.64564 8.69377 5.20174 8.88168C4.75784 9.06952 4.46669 9.50168 4.45938 9.98368C4.45207 10.4656 4.72997 10.9064 5.16797 11.1077C5.15859 11.2298 5.15859 11.3523 5.16797 11.4743C5.16797 13.341 7.34297 14.8577 10.0263 14.8577C12.7097 14.8577 14.8847 13.341 14.8847 11.4743C14.894 11.3523 14.894 11.2298 14.8847 11.1077C15.3043 10.8991 15.5669 10.4679 15.5597 9.99935ZM7.2263 10.8327C7.2263 10.3724 7.59939 9.99935 8.05964 9.99935C8.5199 9.99935 8.89298 10.3724 8.89298 10.8327C8.89298 11.2929 8.5199 11.666 8.05964 11.666C7.83862 11.666 7.62666 11.5782 7.47038 11.4219C7.31409 11.2657 7.2263 11.0537 7.2263 10.8327ZM12.068 13.1243C11.4767 13.5699 10.7493 13.7967 10.0097 13.766C9.26999 13.7967 8.54257 13.5699 7.9513 13.1243C7.87789 13.0349 7.88429 12.9043 7.96613 12.8225C8.04795 12.7407 8.17851 12.7343 8.26797 12.8077C8.76899 13.1752 9.38057 13.3604 10.0013 13.3327C10.6228 13.3665 11.2372 13.1872 11.743 12.8243C11.8025 12.7663 11.8885 12.7444 11.9686 12.7669C12.0486 12.7895 12.1106 12.853 12.1311 12.9336C12.1516 13.0142 12.1275 13.0996 12.068 13.1577V13.1243ZM11.918 11.6993C11.4577 11.6993 11.0847 11.3263 11.0847 10.866C11.0847 10.4058 11.4577 10.0327 11.918 10.0327C12.3782 10.0327 12.7513 10.4058 12.7513 10.866C12.7605 11.0942 12.6756 11.3162 12.5165 11.4799C12.3573 11.6438 12.138 11.7352 11.9097 11.7327L11.918 11.6993Z"/></svg>',
	'github'    => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20"><path d="M10 2C5.58248 2 2 5.67467 2 10.2034C2 13.8286 4.29333 16.9006 7.47124 17.9855C7.51578 17.9953 7.56126 18.0001 7.60686 18C7.904 18 8.01829 17.7821 8.01829 17.5931C8.01829 17.3966 8.01067 16.8823 8.00686 16.1966C7.7423 16.2584 7.47168 16.2906 7.2 16.2926C5.66095 16.2926 5.31048 15.0964 5.31048 15.0964C4.94629 14.1501 4.42133 13.8964 4.42133 13.8964C3.72495 13.4072 4.41752 13.3935 4.47162 13.3935H4.47467C5.27848 13.4644 5.69981 14.243 5.69981 14.243C6.09981 14.9432 6.63543 15.139 7.11467 15.139C7.43104 15.133 7.74258 15.0603 8.02895 14.9257C8.09981 14.3962 8.30705 14.0358 8.53562 13.8286C6.76038 13.6213 4.89295 12.9181 4.89295 9.77523C4.89295 8.87847 5.20381 8.14628 5.71429 7.57485C5.632 7.36762 5.35695 6.53181 5.79276 5.40343C5.85138 5.38951 5.91161 5.38362 5.97181 5.3859C6.26133 5.3859 6.91429 5.49638 7.99314 6.24686C9.3036 5.88024 10.6895 5.88024 12 6.24686C13.0789 5.49638 13.7318 5.3859 14.0213 5.3859C14.0815 5.38361 14.1418 5.3895 14.2004 5.40343C14.6354 6.53181 14.3604 7.36762 14.2789 7.57485C14.7893 8.15009 15.1002 8.88228 15.1002 9.77523C15.1002 12.9249 13.229 13.6175 11.4461 13.8209C11.7318 14.0747 11.9893 14.5752 11.9893 15.3394C11.9893 16.4358 11.9787 17.3211 11.9787 17.5893C11.9787 17.7821 12.0891 18 12.3855 18C12.4336 18.0002 12.4817 17.9954 12.5288 17.9855C15.7105 16.8998 18 13.8255 18 10.2034C18 5.67467 14.4175 2 10 2Z"/></svg>',
	'telegram'  => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 20 20"><path d="M10 1C5.032 1 1 5.032 1 10C1 14.968 5.032 19 10 19C14.968 19 19 14.968 19 10C19 5.032 14.968 1 10 1ZM14.176 7.12C14.041 8.542 13.456 11.998 13.159 13.591C13.033 14.266 12.781 14.491 12.547 14.518C12.025 14.563 11.629 14.176 11.125 13.843C10.333 13.321 9.883 12.997 9.118 12.493C8.227 11.908 8.803 11.584 9.316 11.062C9.451 10.927 11.755 8.83 11.8 8.641C11.8063 8.61237 11.8054 8.58265 11.7976 8.55442C11.7897 8.52619 11.7751 8.5003 11.755 8.479C11.701 8.434 11.629 8.452 11.566 8.461C11.485 8.479 10.225 9.316 7.768 10.972C7.408 11.215 7.084 11.341 6.796 11.332C6.472 11.323 5.86 11.152 5.401 10.999C4.834 10.819 4.393 10.72 4.429 10.405C4.447 10.243 4.672 10.081 5.095 9.91C7.723 8.767 9.469 8.011 10.342 7.651C12.844 6.607 13.357 6.427 13.699 6.427C13.771 6.427 13.942 6.445 14.05 6.535C14.14 6.607 14.167 6.706 14.176 6.778C14.167 6.832 14.185 6.994 14.176 7.12Z"/></svg>',
);

$social_links = array();

for ( $i = 1; $i <= 5; $i++ ) {

	$social_links[ $i ] = array(
		'type'    => get_theme_mod( "misc_social_{$i}", 'none' ),
		'network' => get_theme_mod( "misc_social_{$i}_network", 'instagram' ),
		'label'   => get_theme_mod( "misc_social_{$i}_label" ),
		'image'   => get_theme_mod( "misc_social_{$i}_icon" ),
		'url'     => get_theme_mod( "misc_social_{$i}_url" ),
		'target'  => get_theme_mod( "misc_social_{$i}_target", '_blank' ),
	);

	if ( $social_links[ $i ]['image'] ) {

		$social_links[ $i ]['image_id'] = attachment_url_to_postid( $social_links[ $i ]['image'] );

		if ( 0 === $social_links[ $i ]['image_id'] ) {
			$social_links[ $i ]['image_id'] = null;
		}
	}

	$social_links[ $i ]['alt'] = $social_links[ $i ]['label'] ? $social_links[ $i ]['label'] : '';
}

$social_links = array_filter(
	$social_links,
	function ( $social ) {
		return 'none' !== $social['type'] && ! empty( $social['url'] );
	}
);

?>

<div class="cs-social">
	<?php foreach ( $social_links as $social ) { ?>
		<?php if ( 'preset' === $social['type'] && isset( $social_icons[ $social['network'] ] ) || ( 'custom' === $social['type'] && isset( $social['image_id'] ) ) ) { ?>
			<a class="cs-social__link" href="<?php echo esc_url( $social['url'] ); ?>" target="<?php echo esc_attr( $social['target'] ); ?>" title="<?php echo esc_attr( $social['alt'] ); ?>">
				<?php if ( 'preset' === $social['type'] && isset( $social_icons[ $social['network'] ] ) ) { ?>
					<?php call_user_func( 'printf', '%s', $social_icons[ $social['network'] ] ); ?>
				<?php } elseif ( 'custom' === $social['type'] && isset( $social['image_id'] ) ) { ?>
						<div class="cs-social__image" style="--cs-social-image:url(<?php echo esc_attr( wp_get_attachment_image_url( $social['image_id'], 'full' ) ); ?>);"><span class="screen-reader-text"><?php echo esc_html( $social['alt'] ); ?>"></span></div>
				<?php } ?>
			</a>
		<?php } ?>
	<?php } ?>
</div>
