<?php
session_start();
$path = realpath($_GET['p'] ?? getcwd());
if (!$path || !is_dir($path)) die("Invalid path");

$message = '';

// Delete file/folder
if (isset($_GET['delete'])) {
    $target = $path . '/' . basename($_GET['delete']);
    if (is_dir($target)) rmdir($target);
    elseif (is_file($target)) unlink($target);
    $_SESSION['message'] = "🗑️ Deleted: " . basename($target);
    header("Location: ?p=" . urlencode($path));
    exit;
}

// Download file
if (isset($_GET['download'])) {
    $file = $path . '/' . basename($_GET['download']);
    if (is_file($file)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($file) . '"');
        header('Content-Length: ' . filesize($file));
        readfile($file);
        exit;
    }
}

// Save edited file
if (isset($_POST['savefile'], $_POST['content'])) {
    file_put_contents($path . '/' . basename($_POST['savefile']), $_POST['content']);
    $_SESSION['message'] = "💾 Saved: " . basename($_POST['savefile']);
    header("Location: ?p=" . urlencode($path));
    exit;
}

// Upload / Create folder / Create file
if ($_SERVER['REQUEST_METHOD'] === 'POST' && (!isset($_POST['savefile']))) {
    if (isset($_FILES['up']) && is_uploaded_file($_FILES['up']['tmp_name'])) {
        move_uploaded_file($_FILES['up']['tmp_name'], $path . '/' . $_FILES['up']['name']);
        $_SESSION['message'] = "📤 Uploaded: " . $_FILES['up']['name'];
    }
    if (!empty($_POST['folder'])) {
        mkdir($path . '/' . basename($_POST['folder']));
        $_SESSION['message'] = "📁 Created folder: " . $_POST['folder'];
    }
    if (!empty($_POST['newfile'])) {
        file_put_contents($path . '/' . basename($_POST['newfile']), '');
        $_SESSION['message'] = "📄 Created file: " . $_POST['newfile'];
    }
    header("Location: ?p=" . urlencode($path));
    exit;
}

function formatPermissions($perms) {
    $info = '';
    $info .= ($perms & 0x4000) ? 'd' : '-';
    $info .= ($perms & 0x0100) ? 'r' : '-';
    $info .= ($perms & 0x0080) ? 'w' : '-';
    $info .= ($perms & 0x0040) ? 'x' : '-';
    $info .= ($perms & 0x0020) ? 'r' : '-';
    $info .= ($perms & 0x0010) ? 'w' : '-';
    $info .= ($perms & 0x0008) ? 'x' : '-';
    $info .= ($perms & 0x0004) ? 'r' : '-';
    $info .= ($perms & 0x0002) ? 'w' : '-';
    $info .= ($perms & 0x0001) ? 'x' : '-';
    return $info;
}

function formatSize($bytes) {
    if ($bytes >= 1073741824) return round($bytes / 1073741824, 2) . ' GB';
    if ($bytes >= 1048576) return round($bytes / 1048576, 2) . ' MB';
    if ($bytes >= 1024) return round($bytes / 1024, 2) . ' KB';
    return $bytes . ' B';
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>PHP File Manager</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
            background-color: #1e1e1e;
            color: #eee;
        }
        input, textarea {
            width: 100%;
            max-width: 700px;
            background-color: #2e2e2e;
            border: 1px solid #444;
            color: #eee;
            padding: 8px;
            margin-bottom: 10px;
        }
        textarea {
            height: 400px;
            font-family: monospace;
        }
        table {
            border-collapse: collapse;
            width: 100%;
            max-width: 1000px;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #444;
            text-align: left;
        }
        th {
            background-color: #333;
        }
        tr:nth-child(even) {
            background-color: #2a2a2a;
        }
        tr:nth-child(odd) {
            background-color: #252525;
        }
        a {
            color: #4ea1ff;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
        button {
            padding: 6px 12px;
            background-color: #444;
            color: #eee;
            border: 1px solid #666;
            cursor: pointer;
        }
        button:hover {
            background-color: #666;
        }
        .message {
            padding: 10px;
            background: #2d2d2d;
            border-left: 4px solid #4ea1ff;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
<h2>📁 Current Folder: <?php echo htmlspecialchars($path); ?></h2>

<?php if (!empty($_SESSION['message'])): ?>
    <div class="message">✅ <?php echo $_SESSION['message']; unset($_SESSION['message']); ?></div>
<?php endif; ?>

<form method="get">
    <label>Destination Folder: <input type="text" name="p" value="<?php echo htmlspecialchars($path); ?>"></label>
    <button type="submit">Go</button>
</form>

<?php if ($path !== '/'): ?>
    <p><a href="?p=<?php echo urlencode(dirname($path)); ?>">⬅️ Go Up One Level</a></p>
<?php endif; ?>

<table>
    <thead>
        <tr>
            <th>Name</th>
            <th>Size</th>
            <th>Permissions</th>
            <th style="width: 400px;">Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach (scandir($path) as $item):
            if ($item === '.' || $item === '..') continue;
            $full = $path . '/' . $item;
            $isFile = is_file($full);
            $perms = formatPermissions(fileperms($full));
            $size = $isFile ? formatSize(filesize($full)) : '-';
            $isEditing = isset($_GET['edit']) && $_GET['edit'] === $item;
            echo '<tr><td>';
            if (is_dir($full)) {
                echo "📁 <a href='?p=" . urlencode($full) . "'>" . htmlspecialchars($item) . "</a>";
            } else {
                echo "📄 <a href='?p=" . urlencode($path) . "&edit=" . urlencode($item) . "'>" . htmlspecialchars($item) . "</a>";
            }
            echo "</td><td>$size</td><td>$perms</td><td>";
            if ($isFile) {
                echo "<a href='?p=" . urlencode($path) . "&edit=" . urlencode($item) . "'>✏️ Edit</a> | ";
                echo "<a href='?p=" . urlencode($path) . "&download=" . urlencode($item) . "'>⬇️ Download</a> | ";
            }
            echo "<a href='?p=" . urlencode($path) . "&delete=" . urlencode($item) . "' onclick='return confirm(\"Delete $item?\")'>🗑️ Delete</a>";
            echo '</td></tr>';
            if ($isEditing && $isFile) {
                $content = htmlspecialchars(file_get_contents($full));
                echo "<tr><td colspan='4'><h3>📝 Editing: $item</h3><form method='post'><textarea name='content'>$content</textarea><input type='hidden' name='savefile' value='" . htmlspecialchars($item) . "'><br><button type='submit'>💾 Save</button></form></td></tr>";
            }
        endforeach; ?>
    </tbody>
</table>

<hr>
<h3>📤 Upload / Create</h3>
<form method="post" enctype="multipart/form-data">
    Upload File: <input type="file" name="up"><br>
    New Folder: <input type="text" name="folder"><br>
    New File: <input type="text" name="newfile"><br>
    <button type="submit">Submit</button>
</form>
</body>
</html>