<?php
$operationMode = $config['operation-mode'];
?>
<fieldset class="block">
<h3>Operation mode: <?php echo helpIcon(
    '<p>Think of the operation modes as presets that matches normal use-cases. ' .
    'Usually you want to stick with <i>Varied image responses</i> or perhaps <i>CDN friendly</i>. ' .
    'The Tweaked mode has no presets. That is: Here, you can set all options.</p>' .
    '<p>Changing from ie. "Varied image responses" mode to "Tweaked" mode enables you to see the underlying options for that mode (and tweak them). ' .
    'Changing back will override the tweaks (you will lose them).</p>' .
    '<p>You will never loose your converter configurations by changing mode</p>');
?>
<input type="hidden" name="operation-mode" id="operation_mode" value="<?php echo esc_attr($operationMode); ?>">
<select name="change-operation-mode" id="change_operation_mode">
    <option value="varied-image-responses"<?php if ($operationMode == 'varied-image-responses') echo ' selected'?>>Varied image responses</option>
    <option value="cdn-friendly"<?php if ($operationMode == 'cdn-friendly') echo ' selected'?>>CDN friendly</option>
    <option value="no-conversion"<?php if ($operationMode == 'no-conversion') echo ' selected'?>>No conversion</option>
    <option value="tweaked"<?php if ($operationMode == 'tweaked') echo ' selected'?>>Tweaked</option>
</select></h3>

<?php if ($config['operation-mode'] == 'varied-image-responses') : ?>
<p><div class="p">
    <i>In the "Varied image responses" mode, WebP Express creates redirection rules for images, such that a request for a jpeg will
        result in a webp &ndash; but only if the request comes from a webp-enabled browser. Note that not all CDN's handles varied responses well (see FAQ).
    </i>
</div></p>
<?php endif; ?>
<?php if ($config['operation-mode'] == 'cdn-friendly') : ?>
<p><div class="p">
    <i>In "CDN friendly" mode, a jpeg is always served as a jpeg.
        Instead of varying the image response, WebP Express alters the HTML for webp usage.</i>
    <div class="help">?<div class="popup">
        <p>
            Benefits of not varying image responses:
            <ol>
                <li>CDN's will not have to be set up to forward the Accept header</li>
                <li>Better HIT ratio on CDNs, if the CDN had to be configured to vary on the whole Accept header.</li>
                <li>If a user downloads an image, it will not have wrong file extension</li>
            </ol>
            PS: This mode also works great with <a target="_blank" href="https://da.wordpress.org/plugins/cache-enabler/">Cache Enabler</a>. Instructions are found in the FAQ.
        </p>
        <p>
            PPS: Images refererenced from external CSS or added dynamically with javascript will not be served as webp in this mode.
        </p>
    </div>
    </div>
    <br><br>
    <i>A couple of options are available for automatically triggering webp conversion.</i>
</div></p>
<?php endif; ?>
<?php if ($config['operation-mode'] == 'no-conversion') : ?>
<p>
    <div class="p">
        <i>The "No conversion" mode is for scenarios where you are using another plugin for converting images.
        Perhaps the other plugin doesn't have the redirection or alter HTML feature, or perhaps it doesn't do it as well
        as WebP Express does. PS: The two methods below works great in tandem.</i>
    </div>
</p>
<?php endif; ?>
</fieldset>
<!--
<p><div>
    <i>WebP Express takes care of serving autogenerated WebP images instead of jpeg/png to browsers that supports WebP.</i>
    <div class="help">?<div class="popup"><ol>
        <li>Some redirect rules set up in <i>.htaccess</i> redirects (unconverted) jpeg/png images to a PHP script for handling.</li>
        <li>The PHP script reads the options and passes them to the <i><a target="_blank" href="https://github.com/rosell-dk/webp-convert/">WebP Convert</a></i> library for converting <i>and</i> serving.</li>
        <li>If WebP Convert finds that the image already is converted, it will be served immediately (unless it is bigger than the original, or the original has been modified). Otherwise it will be converted and then served</li>
    </ol></div></div>
</div></p>
-->
